﻿using System;
using System.Threading;
using System.Threading.Tasks;
using gov.va.med.VBECS.Communication.Common;

namespace gov.va.med.VBECS.Communication.Channels
{
    internal class EchoChannel : BaseChannel
    {
        protected override void SendImpl(IMessage aMessage)
        {
            Task.Run(() => do_send(aMessage));
        }

        private void do_send(IMessage aMessage)
        {
            var rnd = new Random();
            var delay = rnd.Next(100, 1000);
            //Emulate work
            Console.WriteLine("Delay [{0}]", delay);
            Thread.Sleep(delay);
            FireMessageReceivedEvent(new RawDataMessage(aMessage.Id, aMessage.GetBytes()));
        }

        protected override void StartImpl()
        {
        }

        protected override void DisconnectImpl()
        {
        }
    }
}